
IF  EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[V_IMPRESSAO_NOTA_FISCAL]'))
DROP VIEW [dbo].[V_IMPRESSAO_NOTA_FISCAL]
GO

CREATE VIEW 
	[dbo].[V_IMPRESSAO_NOTA_FISCAL]
AS             
-------- NOTA FISCAL DE SAIDA
SELECT DISTINCT  
	nf.Cd_Emp, 
	nf.Cd_Filial, 
	nf.Cd_Nf, 
	nf.NF_NF AS NR_NF, 
	nf.DT_EMI_NF,
	nf.NM_FANT, 
	nf.VLR_NF,
	nfe.NR_AUTORIZADOR COLLATE SQL_Latin1_General_CP1_CI_AS AS NR_AUTORIZADOR,
	nfe.DT_RECBTO,  
	0 AS TP_SAI_ENT,
	nfe.CD_NFE_LOTE AS CD_NFE_LOTE, 
	EST_NFE_CARTA_CORRECAO_EST_NF_SAI.NR_CARTA, 
	nf.NFE_REJEITADA,
	nfe.STS_IMP,
	sr.CONTIGENCIA,
	EST_ROTAS_ENTREGA_PRC_FILIAL.CD_ROTA

FROM V_EST_NF_SAI_CAB nf 
	INNER JOIN EST_NF_SERIE Sr ON
	nf.CD_NF_SERIE = Sr.CD_NF_SERIE AND
	Sr.TP_SR_NFE = 1

	LEFT JOIN EST_NF_SAI_NFE nfe ON
	nfe.Cd_Emp = NF.Cd_Emp AND
	nfe.CD_FILIAL = nf.CD_FILIAL AND
	nfe.CD_NF = nf.CD_NF 

	LEFT JOIN EST_NFE_CARTA_CORRECAO_EST_NF_SAI ON
	nfe.Cd_Emp = EST_NFE_CARTA_CORRECAO_EST_NF_SAI.Cd_Emp AND
	nfe.CD_FILIAL = EST_NFE_CARTA_CORRECAO_EST_NF_SAI.CD_FILIAL AND
	nfe.CD_NF = EST_NFE_CARTA_CORRECAO_EST_NF_SAI.CD_NF

----ChkRotaEntrada.value = vbChecked Then
	LEFT JOIN EST_ROTAS_ENTREGA_PRC_FILIAL ON
	nf.CD_EMP = EST_ROTAS_ENTREGA_PRC_FILIAL.CD_EMP AND
	nf.CD_CLI_FILIAL = EST_ROTAS_ENTREGA_PRC_FILIAL.CD_FILIAL
	LEFT OUTER JOIN EST_ROTAS_ENTREGA ON
	EST_ROTAS_ENTREGA_PRC_FILIAL.CD_ROTA = EST_ROTAS_ENTREGA.CD_ROTA

UNION ALL

---- NOTA FISCAL DE ENTRADA
SELECT DISTINCT 
	nf.Cd_Emp, 
	nf.Cd_Filial, 
	nf.Cd_Nf, 
	nf.NR_NF, 
	nf.DT_EMI_NF,
	nf.NM_ORIG_FANT AS NM_FANT, 
	nf.VLR_NF,
	(CASE WHEN nfe.NR_AUTORIZADOR IS NULL THEN 
		Vnfe.NR_AUTORIZADOR COLLATE SQL_Latin1_General_CP1_CI_AS 
	ELSE 
		nfe.NR_AUTORIZADOR COLLATE SQL_Latin1_General_CP1_CI_AS 
	 END) AS NR_AUTORIZADOR, 
	nfe.DT_RECBTO, 
	1 AS TP_SAI_ENT,
	nfe.CD_NFE_LOTE AS CD_NFE_LOTE, 
	EST_NFE_CARTA_CORRECAO_EST_NF_ENT.NR_CARTA, 
	nf.NFE_REJEITADA,
	nfe.STS_IMP,
	sr.CONTIGENCIA,
	0 as CD_ROTA

FROM V_EST_NF_ENT_CAB nf 

	INNER JOIN EST_NF_SERIE Sr ON
	nf.CD_NF_SERIE = Sr.CD_NF_SERIE AND
	Sr.TP_SR_NFE = 1

	INNER JOIN EST_NF_ENT_EF_NF_CTR_NF nfeEmitEmpresa ON
	nf.Cd_Emp = nfeEmitEmpresa.Cd_Emp AND
	nf.CD_FILIAL = nfeEmitEmpresa.CD_FILIAL AND
	nf.CD_NF = nfeEmitEmpresa.CD_NF_ENT

	LEFT JOIN EST_NF_ENT_NFE nfe ON
	nfe.Cd_Emp = NF.Cd_Emp AND
	nfe.CD_FILIAL = nf.CD_FILIAL AND
	nfe.CD_NF = nf.CD_NF

	LEFT JOIN V_EST_NF_ENT_NFE vnfe ON
	nf.Cd_Emp = vnfe.Cd_Emp AND
	nf.CD_FILIAL = vnfe.CD_FILIAL AND
	nf.CD_NF = vnfe.CD_NF

	LEFT JOIN EST_NFE_CARTA_CORRECAO_EST_NF_ENT ON
	nfe.Cd_Emp = EST_NFE_CARTA_CORRECAO_EST_NF_ENT.Cd_Emp AND
	nfe.CD_FILIAL = EST_NFE_CARTA_CORRECAO_EST_NF_ENT.CD_FILIAL AND
	nfe.CD_NF     = EST_NFE_CARTA_CORRECAO_EST_NF_ENT.CD_NF

------ If CHK_NaoValidada.value = vbChecked Then
AND ((CASE WHEN nfe.NR_AUTORIZADOR IS NULL THEN
       Vnfe.NR_AUTORIZADOR COLLATE SQL_Latin1_General_CP1_CI_AS
    ELSE
       nfe.NR_AUTORIZADOR COLLATE SQL_Latin1_General_CP1_CI_AS
   END) IS NULL or nf.NFE_REJEITADA=1)


UNION ALL
-------- CARTA DE CORREÇÃO
SELECT DISTINCT 
	nf.Cd_Emp,
	nf.Cd_Filial,
	nf.Cd_Nf,
	nf.NF_NF AS NR_NF,
	nf.DT_EMI_NF,
	nf.NM_FANT,
	nf.VLR_NF,
	EST_NFE_CARTA_CORRECAO_VALIDADA.NR_AUTORIZADOR, 
	EST_NFE_CARTA_CORRECAO_VALIDADA.DT_RECBTO,
	2 AS TP_SAI_ENT,
	0 AS CD_NFE_LOTE,
	EST_NFE_CARTA_CORRECAO_EST_NF_SAI.NR_CARTA,
	0  NFE_REJEITADA,
	EST_NFE_CARTA_CORRECAO_VALIDADA.STS_IMP,
	0 as CONTIGENCIA,
	0 as CD_ROTA

FROM EST_NFE_CARTA_CORRECAO  INNER JOIN EST_NFE_CARTA_CORRECAO_VALIDADA     ON 
	EST_NFE_CARTA_CORRECAO.CD_CTR_CARTA_CORRECAO = EST_NFE_CARTA_CORRECAO_VALIDADA.CD_CTR_CARTA_CORRECAO
	
	INNER JOIN EST_NFE_CARTA_CORRECAO_EST_NFE_LOTE ON 
	EST_NFE_CARTA_CORRECAO.CD_CTR_CARTA_CORRECAO = EST_NFE_CARTA_CORRECAO_EST_NFE_LOTE.CD_CTR_CARTA_CORRECAO
	INNER JOIN EST_NFE_CARTA_CORRECAO_EST_NF_SAI   ON 
	EST_NFE_CARTA_CORRECAO_EST_NF_SAI.CD_CTR_CARTA_CORRECAO = EST_NFE_CARTA_CORRECAO.CD_CTR_CARTA_CORRECAO
	INNER JOIN V_EST_NF_SAI NF ON 
	NF.CD_EMP = EST_NFE_CARTA_CORRECAO_EST_NF_SAI.CD_EMP AND 
	NF.CD_FILIAL = EST_NFE_CARTA_CORRECAO_EST_NF_SAI.CD_FILIAL AND 
	EST_NFE_CARTA_CORRECAO_EST_NF_SAI.CD_NF = NF.CD_NF
   

GO


